DROP PROCEDURE [hips].[PatientMasterInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date: 11 Oct 2012
-- Description:   Inserts a new record into the Patient Master Table
-- Modified: 23/11/2012 sbiber added StatePatientId
-- Modified: 18/12/2012 sbiber removed PcehrAdvertised
-- Modified: 16/06/2013 pstall01 added date of death indicator
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterInsert] 
(

	@CurrentSexId INT,
	@DeathIndicatorId INT = null,
	@DateOfBirth DATETIME,
	@DateOfDeath DATETIME = null,
	@MedicareNumber VARCHAR(12) = null,
	@MedicareIrn VARCHAR(3) = null,
	@IsMedicareNumberValid INT = null,
	@DvaNumber VARCHAR(18) = NULL,
	@StatePatientId VARCHAR(64) = NULL,
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
	
	IF (@MedicareIrn = '0') 
	BEGIN
		SET @MedicareIrn = NULL
	END  

    DECLARE @intErrorCode INT
		,@PatientMasterId INT

    SET @intErrorCode = 0

    INSERT
     INTO [hips].[PatientMaster]
         ( 
           [CurrentSexId]
		 , [DeathIndicatorId]
         , [DateOfBirth]
         , [DateOfDeath]
         , [MedicareNumber]
         , [MedicareIrn]
         , [IsMedicareNumberValid]
         , [DvaNumber]
		 , [StatePatientId]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         )
    VALUES
         ( 
           @CurrentSexId
		 , @DeathIndicatorId 
         , @DateOfBirth
         , @DateOfDeath
         , @MedicareNumber
         , @MedicareIrn
         , @IsMedicareNumberValid
         , @DvaNumber
		 , @StatePatientId
         , GETDATE()
         , @UserModified
         , GETDATE()
         , @UserModified
         )

    SELECT @intErrorCode = @@ERROR 
		, @PatientMasterId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
		SELECT pm.[PatientMasterID]
			 , COALESCE (pmi.RegisteredSexId,pm.CurrentSexId, -1) AS RegisteredSexId
			 , COALESCE (pm.CurrentSexId, -1) AS CurrentSexId
			 , pmi.Ihi
			 , COALESCE (pmi.IhiStatusId, -1) AS IhiStatusId
			 , ihis.Description AS IhiStatus
			 , COALESCE (pmi.IhiRecordStatusId, -1) AS IhiRecordStatusId
			 , pmi.[RegisteredFamilyName]
			 , pmi.[RegisteredGivenName]
		     , irs.Description AS IhiRecordStatus
			 , pmi.DateLastValidated AS IhiLastValidated
			 , pm.[MedicareNumber]
			 , pm.[MedicareIrn]
			 , pm.[IsMedicareNumberValid]
			 , pm.[DvaNumber]
			 , pm.[StatePatientId]
			 , pm.[DateOfBirth]
			 , pm.[DateOfDeath]
			 , pm.[DeathIndicatorId]
			 , pm.[DateCreated]
			 , pm.[UserCreated]
			 , pm.[DateModified]
			 , pm.[UserModified]         
	     FROM	[hips].[PatientMaster] AS pm
         LEFT JOIN [hips].[PatientMasterIhi] AS pmi ON pmi.[PatientMasterID] = pm.[PatientMasterID]
         LEFT JOIN [hips].IhiRecordStatus AS irs on irs.IhiRecordStatusId = pmi.IhiRecordStatusId
		 LEFT JOIN [hips].IhiStatus AS ihis on ihis.IhiStatusId = pmi.IhiStatusId

        WHERE	pm.[PatientMasterID] = @PatientMasterID
    END

    RETURN(@intErrorCode)
END
GO

